/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementRenderer;
import xaero.map.element.render.ElementReader;
import xaero.map.element.render.ElementRenderInfo;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.element.render.ElementRenderProvider;
import xaero.map.element.render.ElementRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapDimension;

public class MapElementRenderHandler {
    private final List<ElementRenderer<?, ?, ?>> renderers;
    protected final ElementRenderLocation location;
    private HoveredMapElementHolder<?, ?> previousHovered;
    private boolean previousHoveredPresent;
    private boolean renderingHovered;
    private Object workingHovered;
    private ElementRenderer<?, ?, ?> workingHoveredRenderer;

    private MapElementRenderHandler(List<ElementRenderer<?, ?, ?>> renderers, ElementRenderLocation location) {
        this.renderers = renderers;
        this.location = location;
    }

    public void add(ElementRenderer<?, ?, ?> renderer) {
        this.renderers.add(renderer);
    }

    public static <E, C> HoveredMapElementHolder<E, C> createResult(E hovered, ElementRenderer<?, ?, ?> hoveredRenderer) {
        ElementRenderer<?, ?, ?> rendererCast = hoveredRenderer;
        return new HoveredMapElementHolder(hovered, rendererCast);
    }

    private <E> ElementRenderer<E, ?, ?> getRenderer(HoveredMapElementHolder<E, ?> holder) {
        return holder.getRenderer();
    }

    public HoveredMapElementHolder<?, ?> render(GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, float partialTicks) {
        MapProcessor mapProcessor = WorldMapSession.getCurrentSession().getMapProcessor();
        MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
        double mapDimScale = mapDimension.calculateDimScale(mapProcessor.getWorldDimensionTypeRegistry());
        TextureManager textureManager = mc.func_110434_K();
        FontRenderer fontRenderer = mc.field_71466_p;
        textureManager.func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double baseScale = 1.0 / scale;
        Collections.sort(this.renderers);
        if (this.previousHovered == null) {
            this.previousHovered = oldHovered;
        }
        this.workingHovered = null;
        this.workingHoveredRenderer = null;
        this.previousHoveredPresent = false;
        ElementRenderInfo renderInfo = new ElementRenderInfo(this.location, mc.func_175606_aa(), (PlayerEntity)mc.field_71439_g, new Vector3d(cameraX, -1.0, cameraZ), mouseX, mouseZ, scale, cave, partialTicks, brightness, screenSizeBasedScale, null, mapDimScale, mapDimension.getDimId());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, -980.0);
        matrixStack.func_227862_a_((float)baseScale, (float)baseScale, 1.0f);
        for (ElementRenderer<?, ?, ?> renderer : this.renderers) {
            this.renderWithRenderer(renderer, matrixStack, renderInfo, renderTypeBuffers, rendererProvider, width, height, baseScale, playerDimDiv, true, 0, 0);
        }
        if (this.previousHoveredPresent) {
            this.renderHoveredWithRenderer(this.previousHovered, matrixStack, renderTypeBuffers, rendererProvider, renderInfo, baseScale, playerDimDiv, true, 0, 0);
        }
        this.previousHoveredPresent = false;
        int indexLimit = 19490;
        for (ElementRenderer<?, ?, ?> renderer : this.renderers) {
            int elementIndex = 0;
            elementIndex = this.renderWithRenderer(renderer, matrixStack, renderInfo, renderTypeBuffers, rendererProvider, width, height, baseScale, playerDimDiv, false, elementIndex, indexLimit);
            matrixStack.func_227861_a_(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        if (this.previousHoveredPresent) {
            this.renderHoveredWithRenderer(this.previousHovered, matrixStack, renderTypeBuffers, rendererProvider, renderInfo, baseScale, playerDimDiv, false, 0, indexLimit);
        }
        matrixStack.func_227865_b_();
        textureManager.func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        this.previousHovered = this.previousHovered != null && this.previousHovered.is(this.workingHovered) ? this.previousHovered : (this.workingHovered == null ? null : MapElementRenderHandler.createResult(this.workingHovered, this.workingHoveredRenderer));
        return this.previousHovered;
    }

    private <E, C> int renderHoveredWithRenderer(HoveredMapElementHolder<E, C> hoveredHolder, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, ElementRenderInfo renderInfo, double baseScale, double playerDimDiv, boolean pre, int elementIndex, int indexLimit) {
        ElementRenderer<E, C, ?> renderer = hoveredHolder.getRenderer();
        if (!renderer.shouldRenderHovered(pre)) {
            return elementIndex;
        }
        ElementReader<E, C, ?> reader = renderer.getReader();
        E hoveredCast = hoveredHolder.getElement();
        renderer.preRender(renderInfo, renderTypeBuffers, rendererProvider, pre);
        matrixStack.func_227860_a_();
        if (!pre) {
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        }
        double rendererDimDiv = renderer.shouldBeDimScaled() ? playerDimDiv : 1.0;
        this.renderingHovered = true;
        if (!reader.isHidden(hoveredCast, renderer.getContext()) && this.transformAndRenderElement(renderer, hoveredCast, true, matrixStack, renderInfo, renderTypeBuffers, rendererProvider, baseScale, rendererDimDiv, pre, elementIndex, indexLimit) && !pre) {
            ++elementIndex;
        }
        this.renderingHovered = false;
        matrixStack.func_227865_b_();
        renderer.postRender(renderInfo, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends ElementRenderer<E, C, R>> int renderWithRenderer(ElementRenderer<E, C, R> renderer, MatrixStack matrixStack, ElementRenderInfo renderInfo, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, int width, int height, double baseScale, double playerDimDiv, boolean pre, int elementIndex, int indexLimit) {
        ElementRenderLocation location = this.location;
        if (!renderer.shouldRender(location, pre)) {
            return elementIndex;
        }
        ElementReader<E, C, R> reader = renderer.getReader();
        ElementRenderProvider<E, C> provider = renderer.getProvider();
        C context = renderer.getContext();
        double rendererDimDiv = renderer.shouldBeDimScaled() ? playerDimDiv : 1.0;
        renderer.preRender(renderInfo, renderTypeBuffers, rendererProvider, pre);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            E e = provider.setupContextAndGetNext(location, context);
            if (e == null || reader.isHidden(e, context) || !reader.isOnScreen(e, renderInfo.renderPos.field_72450_a, renderInfo.renderPos.field_72449_c, width, height, renderInfo.scale, renderInfo.screenSizeBasedScale, rendererDimDiv, context, renderInfo.partialTicks) || !this.transformAndRenderElement(renderer, e, false, matrixStack, renderInfo, renderTypeBuffers, rendererProvider, baseScale, rendererDimDiv, pre, elementIndex, indexLimit) || pre) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.postRender(renderInfo, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends ElementRenderer<E, C, R>> boolean transformAndRenderElement(ElementRenderer<E, C, R> renderer, E e, boolean highlighted, MatrixStack matrixStack, ElementRenderInfo renderInfo, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double baseScale, double rendererDimDiv, boolean pre, int elementIndex, int indexLimit) {
        ElementReader<E, C, R> reader = renderer.getReader();
        C context = renderer.getContext();
        if (!this.renderingHovered) {
            if (reader.isInteractable(renderInfo.location, e) && reader.isHoveredOnMap(this.location, e, renderInfo.mouseX, renderInfo.mouseZ, renderInfo.scale, renderInfo.screenSizeBasedScale, rendererDimDiv, context, renderInfo.partialTicks)) {
                this.workingHovered = e;
                this.workingHoveredRenderer = renderer;
            }
            if (!this.previousHoveredPresent && this.previousHovered != null && this.previousHovered.is(e)) {
                this.previousHoveredPresent = true;
                return false;
            }
        }
        matrixStack.func_227860_a_();
        double offX = (reader.getRenderX(e, context, renderInfo.partialTicks) / rendererDimDiv - renderInfo.renderPos.field_72450_a) / baseScale;
        double offZ = (reader.getRenderZ(e, context, renderInfo.partialTicks) / rendererDimDiv - renderInfo.renderPos.field_72449_c) / baseScale;
        long roundedOffX = Math.round(offX);
        long roundedOffZ = Math.round(offZ);
        double partialX = offX - (double)roundedOffX;
        double partialY = offZ - (double)roundedOffZ;
        matrixStack.func_227861_a_((double)roundedOffX, (double)roundedOffZ, 0.0);
        boolean result = false;
        if (pre) {
            renderer.renderElementShadow(e, highlighted, (float)renderInfo.screenSizeBasedScale, partialX, partialY, renderInfo, matrixStack, renderTypeBuffers, rendererProvider);
        } else {
            double optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit);
            result = renderer.renderElement(e, highlighted, optionalDepth, (float)renderInfo.screenSizeBasedScale, partialX, partialY, renderInfo, matrixStack, renderTypeBuffers, rendererProvider);
        }
        matrixStack.func_227865_b_();
        return result;
    }

    private double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    public static final class Builder {
        private Builder() {
        }

        public MapElementRenderHandler build() {
            ArrayList<MapElementRenderer> renderers = new ArrayList<MapElementRenderer>();
            if (SupportMods.minimap()) {
                renderers.add(SupportMods.xaeroMinimap.getWaypointRenderer());
            }
            renderers.add(WorldMap.trackedPlayerRenderer);
            return new MapElementRenderHandler(renderers, ElementRenderLocation.WORLD_MAP);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

