/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import xaero.map.MapWriter;
import xaero.map.MapWriterForge;
import xaero.map.WorldMap;
import xaero.map.WorldMapClientOnly;
import xaero.map.WorldMapClientOnlyForge;
import xaero.map.biome.BiomeGetter;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.events.ClientEventsForge;
import xaero.map.events.CommonEventsForge;
import xaero.map.events.ModClientEventsForge;
import xaero.map.events.ModCommonEventsForge;
import xaero.map.mods.SupportMods;
import xaero.map.mods.SupportModsForge;
import xaero.map.region.OverlayManager;
import xaero.map.server.WorldMapServer;
import xaero.map.server.WorldMapServerForge;

@Mod(value="xaeroworldmap")
public class WorldMapForge
extends WorldMap {
    private String fileLayoutID = "worldmap";

    public WorldMapForge(FMLJavaModLoadingContext context) {
        context.getModEventBus().addListener(this::loadCommonForge);
        context.getModEventBus().addListener(this::loadClientForge);
        context.getModEventBus().addListener(this::loadServerForge);
        this.registerCommonEvents(context);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.registerClientEvents(context);
        }
    }

    protected void registerClientEvents(FMLJavaModLoadingContext context) {
        events = new ClientEventsForge();
        modEvents = new ModClientEventsForge();
        MinecraftForge.EVENT_BUS.register((Object)events);
        context.getModEventBus().register((Object)modEvents);
    }

    protected void registerCommonEvents(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        commonEvents = new CommonEventsForge();
        MinecraftForge.EVENT_BUS.register((Object)commonEvents);
        context.getModEventBus().register((Object)new ModCommonEventsForge());
    }

    private void loadClientForge(FMLClientSetupEvent event) {
        try {
            this.loadClient();
            ModContainer modContainer = ModList.get().getModContainerById("xaeroworldmap").orElse(null);
            ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this::loadLater);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadCommonForge(FMLCommonSetupEvent event) {
        this.loadCommon();
    }

    private void loadServerForge(FMLDedicatedServerSetupEvent event) {
        this.loadServer();
        ModContainer modContainer = ModList.get().getModContainerById("xaeroworldmap").orElse(null);
        ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this::loadLaterServer);
    }

    @Override
    protected Path fetchModFile() {
        return FMLLoader.getLoadingModList().getModFileById("xaeroworldmap").getFile().getFilePath();
    }

    @Override
    protected String getFileLayoutID() {
        return this.fileLayoutID;
    }

    @Override
    protected SupportMods createSupportMods() {
        return new SupportModsForge();
    }

    @Override
    protected WorldMapClientOnly createClientLoad() {
        return new WorldMapClientOnlyForge();
    }

    @Override
    protected WorldMapServer createServerLoad() {
        return new WorldMapServerForge();
    }

    @Override
    public MapWriter createWriter(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter) {
        return new MapWriterForge(overlayManager, blockStateShortShapeCache, biomeGetter);
    }

    @Override
    protected String getModInfoVersion() {
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById("xaeroworldmap").get();
        return modContainer.getModInfo().getVersion().toString();
    }
}

